/*
 * home_dir() is called by parse_profile() and read_store() to
 * determine the home directory of the user running r2sync. It returns
 * a string allocated on the heap, or NULL if an error occurred (no
 * home dir defined or out of memory).
 */

#include "stdincls.h"


/* home_dir -- get the name of the user's home directory, allocated on heap */
EXPORT char *home_dir(void)
{
  struct passwd *pwd;
  char *dir;

  errno = 0;
  if (!(pwd = getpwuid(getuid()))) return NULL;
  if (!(dir = strdup(pwd->pw_dir))) return NULL;
  return dir;
}
