/*
  hash() is used by store_open() in s-store.c. It computes a hash for
  a null-terminated text string, starting from a seed value.
*/

#include "stdincls.h"


#define HASHSEED 5381
EXPORTDEF(HASHSEED)


/* hash -- compute a hash of a string s (Dan Bernstein's djb2) */
EXPORT unsigned long hash(unsigned long seed, const char *s)
{
  assert(s);
  for (; *s; s++) seed = ((seed << 5) + seed) ^ (unsigned int)*s;
  return seed;
}
