/*
  print() is like fprintf(), but also counts the total number of bytes
  written, for statistical purposes.

  print1() is like fputs(), but also counts the total number of bytes
  written, for statistical purposes.
*/

#include "stdincls.h"


/* The array is only for statistical purposes */
#define MAX_FDS 10
static long long bytes_sent[MAX_FDS] = {0,0,0,0,0,0,0,0,0,0};


/* print -- write a string to a stream, using a format */
EXPORT int print(FILE *stream, const char *format,...)
{
  va_list ap;
  int n, fd = fileno(stream);

  va_start(ap, format);
  n = vfprintf(stream, format, ap);
  va_end(ap);

  if (n > 0 && fd < MAX_FDS) bytes_sent[fd] += n;

  return n;
}


/* print1 -- write a string to a stream */
EXPORT int print1(FILE *stream, const char *s)
{
  size_t n = strlen(s);
  int fd = fileno(stream);

  if (fputs(s, stream) == EOF) return -1;
  if (fd < MAX_FDS) bytes_sent[fd] += n;
  return n;
}


/* get_bytes_sent -- return the # of bytes sent on a file descriptor */
EXPORT long long get_bytes_sent(int fd)
{
  return fd < MAX_FDS ? bytes_sent[fd] : -1;
}
